/*** 1.   ũƮ ***/

CREATE TABLE TB_Main (seq INT
                    , main_code UNIQUEIDENTIFIER
                    , date DATE )
CREATE TABLE TB_Sub (value INT NOT NULL
                   , sub_code NVARCHAR(50)
                   , date DATE
                   , txt UNIQUEIDENTIFIER )

INSERT INTO TB_Main 
SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS seq
	, NEWID() AS main_code
	, DATEADD(d, a.number, '2020-01-01') date 
FROM master..spt_values a (NOLOCK) , (SELECT number 
				      FROM master..spt_values (NOLOCK) 
				      WHERE type = 'p' AND number < 20) b  
WHERE type = 'p'
AND a.number <= 365

INSERT INTO TB_Sub
SELECT ISNULL(CONVERT(INT, RIGHT(a.seq * b.high * b.number, 2)), 0) AS value
	, CONVERT(NVARCHAR(50),a.main_code) AS sub_code 
	, GETDATE() AS date 	
	, NEWID() AS txt
FROM TB_Main a, master..spt_values (NOLOCK) b
WHERE b.type = 'P'
AND b.number BETWEEN 1 AND 10

CREATE CLUSTERED INDEX CIDX_Main ON TB_Main(date)
CREATE INDEX NIDX01_Sub ON TB_Sub(sub_code,value) 
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT m.seq, m.main_code, (SELECT MAX(value) 
						 FROM TB_Sub s 
						 WHERE s.sub_code = m.main_code) AS value
FROM TB_Main m
WHERE date BETWEEN '2020-01-01' AND '2020-01-07'
GO


/*** 6. [TO-BE]   ***/

SELECT m.seq, m.main_code, (SELECT MAX(value) 
						 FROM TB_Sub s 
						 WHERE s.sub_code=CONVERT(NVARCHAR(50), m.main_code)) AS value
FROM TB_Main m
WHERE date BETWEEN '2020-01-01' AND '2020-01-07'
GO